<?php
/**
 * Rélisation du système de commentaires en PHP/JS par c2script.com
 */
session_start();
include '../config.php';

// Fonction pour rediriger avec un message
function redirectWithMessage($url, $message, $color = 'green') {
    echo '<!DOCTYPE html>';
    echo '<html lang="fr">';
    echo '<head>';
    echo '    <meta charset="UTF-8">';
    echo '    <title>Redirection</title>';
    echo '</head>';
    echo '<body>';
    echo '    <p style="color: ' . $color . '; font-family: Arial, sans-serif; font-size: 18px; text-align: center; margin-top: 50px;">' . str_replace('Redirection...', '', htmlspecialchars($message)) . '</p>';
    //echo '    <meta http-equiv="refresh" content="2;url=' . htmlspecialchars($url) . '">';
    echo '<a href="' . htmlspecialchars($url) . '" style="display: block; text-align: center; margin-top: 20px; font-family: Arial, sans-serif;">OK</a>';
    echo '</body>';
    echo '</html>';
    exit;
}


// Vérifier l'authentification
if (!isset($_SESSION['admin_logged_in'])) {
    $error = '';
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
        if ($_POST['password'] === $C2PARAM['admin_password']) {
            $_SESSION['admin_logged_in'] = true;
            redirectWithMessage('index.php', 'Connexion réussie. Redirection...');
        } else {
            $error = 'Mot de passe incorrect.';
        }
    }
    // Afficher le formulaire de connexion
    ?>
    <!DOCTYPE html>
    <html lang="fr">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Administration - Connexion</title>
        <style>
            body {
                font-family: Arial, sans-serif;
                max-width: 400px;
                margin: 100px auto;
                padding: 20px;
                background-color: #f4f4f4;
            }
            .login-form {
                background: white;
                padding: 30px;
                border-radius: 8px;
                box-shadow: 0 0 10px rgba(0,0,0,0.1);
            }
            h1 {
                color: #2f5496;
                text-align: center;
                margin-bottom: 30px;
                margin-top: 0;
            }
            label {
                display: block;
                margin-bottom: 5px;
                font-weight: bold;
                color: #333;
            }
            input[type="password"] {
                width: 100%;
                padding: 10px;
                margin: 10px 0 20px;
                border: 1px solid #ddd;
                border-radius: 4px;
                box-sizing: border-box;
                font-size: 14px;
            }
            input[type="password"]:focus {
                outline: none;
                border-color: #2f5496;
            }
            button {
                width: 100%;
                padding: 12px;
                background: #2f5496;
                color: white;
                border: none;
                border-radius: 4px;
                cursor: pointer;
                font-size: 16px;
                font-weight: bold;
            }
            button:hover {
                background: #4040c0;
            }
            .error {
                color: red;
                background: #f8d7da;
                border: 1px solid #f5c6cb;
                padding: 10px;
                border-radius: 4px;
                margin-bottom: 15px;
                text-align: center;
            }
        </style>
    </head>
    <body>
        <div class="login-form">
            <h1>Administration</h1>
            <?php if ($error): ?>
                <p class="error"><?= htmlspecialchars($error) ?></p>
            <?php endif; ?>
            <form method="POST">
                <label for="password">Mot de passe administrateur :</label>
                <input type="password" id="password" name="password" autocomplete="new-password" required>
                <button type="submit">Se connecter</button>
            </form>
        </div>
    </body>
    </html>
    <?php
    exit;
}

// Fonction pour lister les commentaires
function listComments($page_id = null) {
    global $C2PARAM;
    $comments = [];
    if (is_dir($C2PARAM['comments_dir'])) {
        $dirs = glob($C2PARAM['comments_dir'] . '*', GLOB_ONLYDIR);
        foreach ($dirs as $dir) {
            $files = glob($dir . '/*.json');
            foreach ($files as $file) {
                $data = json_decode(file_get_contents($file), true);
                if ($data && ($page_id === null || $data['page_id'] === $page_id)) {
                    $comments[] = $data;
                }
            }
        }
    }
    return $comments;
}
// Fonction pour lister les page_id uniques
function listPageIds() {
    global $C2PARAM;
    $page_ids = [];
    if (is_dir($C2PARAM['comments_dir'])) {
        $dirs = glob($C2PARAM['comments_dir'] . '*', GLOB_ONLYDIR);
        foreach ($dirs as $dir) {
            $page_id = basename($dir);
            $files = glob($dir . '/*.json');
            if (!empty($files)) {
                $page_ids[] = $page_id;
            }
        }
    }
    return $page_ids;
}

// Gérer la déconnexion
if (isset($_GET['logout'])) {
    session_destroy();
    redirectWithMessage('index.php', 'Déconnexion réussie. Redirection...');
}

// Gérer l'ajout d'une nouvelle langue
if (isset($_GET['action']) && $_GET['action'] === 'add_language' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_lang_code = strtolower(trim($_POST['new_lang_code']));
    
    // Charger les traductions existantes
    if (file_exists('../translations.php')) {
        include '../translations.php';
        
        // Vérifier si la langue n'existe pas déjà
        if (!isset($translations[$new_lang_code])) {
            // Copier les traductions de la langue actuelle comme base
            $current_lang = $C2PARAM['current_language'] ?? 'fr';
            $translations[$new_lang_code] = $translations[$current_lang];
            
            // Sauvegarder les traductions
            $export = "<?php\n\$translations = ";
            $export .= var_export($translations, true);
            $export .= ";\n?>";
            file_put_contents('../translations.php', $export);
            
            redirectWithMessage('index.php?action=config&lang_added=1', 'Langue ajoutée avec succès. Redirection...');
        } else {
            redirectWithMessage('index.php?action=config&lang_error=exists', 'Cette langue existe déjà.', 'red');
        }
    }
}

// Gérer les actions
$comment = null;

if (isset($_GET['action'])) {
    $action = $_GET['action'];
    if ($action === 'config' && $_SERVER['REQUEST_METHOD'] === 'POST') {
        // Sauvegarder les configurations
        $new_config = "<?php\n// Configuration du système de commentaires\n\n";
        $new_config .= "\$C2PARAM = array();\n\n";
        $new_config .= "// Mode de validation : 'direct' ou 'ftp'\n";
        $new_config .= "\$C2PARAM['validation_mode'] = '" . addslashes($_POST['validation_mode']) . "';\n\n";
        $new_config .= "// Mot de passe pour l'administration\n";
        $new_config .= "\$C2PARAM['admin_password'] = '" . addslashes($_POST['admin_password']) . "';\n\n";
        $new_config .= "// Email de l'administrateur pour les notifications\n";
        $new_config .= "\$C2PARAM['admin_email'] = '" . addslashes($_POST['admin_email']) . "';\n\n";
        $new_config .= "// Configuration SMTP pour PHPMailer\n";
        $new_config .= "\$C2PARAM['use_smtp'] = " . (isset($_POST['use_smtp']) ? 'true' : 'false') . ";\n";
        $new_config .= "\$C2PARAM['smtp_host'] = '" . addslashes($_POST['smtp_host']) . "';\n";
        $new_config .= "\$C2PARAM['smtp_username'] = '" . addslashes($_POST['smtp_username']) . "';\n";
        $new_config .= "\$C2PARAM['smtp_password'] = '" . addslashes($_POST['smtp_password']) . "';\n";
        $new_config .= "\$C2PARAM['smtp_port'] = " . intval($_POST['smtp_port']) . ";\n";
        $new_config .= "\$C2PARAM['smtp_secure'] = '" . addslashes($_POST['smtp_secure']) . "';\n\n";
        $new_config .= "// Dossier pour les commentaires JSON\n";
        $new_config .= "\$C2PARAM['comments_dir'] = __DIR__ . '/commentaires/';\n\n";
        $new_config .= "// Configuration pour afficher les commentaires récents en premier (true) ou anciens en premier (false)\n";
        $new_config .= "\$C2PARAM['recent_first'] = " . (isset($_POST['recent_first']) ? 'true' : 'false') . ";\n\n";
        $new_config .= "// Configuration pour afficher les boutons \"répondre\" aux commentaires\n";
        $new_config .= "\$C2PARAM['afficher_boutons_repondre'] = " . (isset($_POST['afficher_boutons_repondre']) ? 'true' : 'false') . ";\n\n";
        $new_config .= "// Profondeur maximale des réponses (0 = pas de réponses, 1 = réponses aux commentaires principaux, 2 = réponses aux réponses, etc.)\n";
        $new_config .= "\$C2PARAM['max_reply_depth'] = " . intval($_POST['max_reply_depth']) . ";\n\n";
        $new_config .= "// URL du site pour les commentaires\n";
        $new_config .= "if (isset(\$_SERVER['HTTP_HOST']) && strpos(\$_SERVER['HTTP_HOST'], 'localhost') !== false) {\n";
        $new_config .= "    \$C2PARAM['URL_SITE'] = 'http://localhost/travaux/nemodus';\n";
        $new_config .= "} else {\n";
        $new_config .= "    \$C2PARAM['URL_SITE'] = 'https://www.nemodus.com/blog/blog_commentaires'; // sans slash à la fin\n";
        $new_config .= "}\n\n";
        $new_config .= "// Configuration anti-spam\n";
        $new_config .= "\$C2PARAM['min_form_time'] = " . intval($_POST['min_form_time']) . ";\n";
        $new_config .= "\$C2PARAM['captcha_type'] = '" . addslashes($_POST['captcha_type']) . "';\n";
        $new_config .= "\$C2PARAM['hcaptcha_sitekey'] = '" . addslashes($_POST['hcaptcha_sitekey']) . "';\n";
        $new_config .= "\$C2PARAM['hcaptcha_secretkey'] = '" . addslashes($_POST['hcaptcha_secretkey']) . "';\n";
        $new_config .= "\$C2PARAM['hcaptcha_size'] = '" . addslashes($_POST['hcaptcha_size']) . "';\n";
        $new_config .= "\$C2PARAM['max_comment_length'] = " . intval($_POST['max_comment_length']) . ";\n";
        $new_config .= "\$C2PARAM['comment_truncate_lines'] = " . intval($_POST['comment_truncate_lines']) . ";\n";
        $new_config .= "\$C2PARAM['read_more_color'] = '" . addslashes($_POST['read_more_color']) . "';\n";
        $new_config .= "\$C2PARAM['read_more_size'] = '" . addslashes($_POST['read_more_size']) . "';\n";
        $new_config .= "\$C2PARAM['comments_per_page'] = " . intval($_POST['comments_per_page']) . ";\n";
        $new_config .= "\$C2PARAM['display_mode'] = '" . addslashes($_POST['display_mode']) . "';\n\n";

        $new_config .= "\ninclude 'translations.php';\n\n";
        $new_config .= "// Fonction pour récupérer les traductions\n";
        $new_config .= "function getTranslation(\$key) {\n";
        $new_config .= "    global \$C2PARAM;\n";
        $new_config .= "    \$lang = \$C2PARAM['current_language'] ?? 'fr';\n";
        $new_config .= "    return \$C2PARAM['translations'][\$lang][\$key] ?? \$key;\n";
        $new_config .= "}\n\n";
        $new_config .= "// Configuration de la langue actuelle\n";
        $new_config .= "\$C2PARAM['current_language'] = '" . addslashes($_POST['current_language']) . "';\n\n";
        
        // Code generator settings (chemin et page_id)
        $new_config .= "// Chemin d'installation par défaut pour le générateur de code\n";
        $new_config .= "\$C2PARAM['default_install_path'] = '" . addslashes($_POST['default_install_path']) . "';\n\n";
        $new_config .= "// ID de page par défaut pour le générateur de code\n";
        $new_config .= "\$C2PARAM['default_page_id'] = '" . addslashes($_POST['default_page_id']) . "';\n\n";
        
        $new_config .= "// Traductions par langue\n";
        $new_config .= "\$C2PARAM['translations'] = \$translations;\n\n";

        // Ajouter les configurations de thème
        $new_config .= "\n// Configuration du thème et de la personnalisation\n";
        $new_config .= "\$C2PARAM['theme'] = array();\n\n";
        $new_config .= "// Éléments du formulaire\n";
        $new_config .= "\$C2PARAM['theme']['form'] = array(\n";
        $new_config .= "    'text_size' => '" . addslashes($_POST['theme']['form']['text_size']) . "',\n";
        $new_config .= "    'color' => '" . addslashes($_POST['theme']['form']['color']) . "'\n";
        $new_config .= ");\n\n";
        $new_config .= "\$C2PARAM['theme']['pseudo'] = array(\n";
        $new_config .= "    'text_size' => '" . addslashes($_POST['theme']['pseudo']['text_size']) . "',\n";
        $new_config .= "    'color' => '" . addslashes($_POST['theme']['pseudo']['color']) . "',\n";
        $new_config .= "    'margin_left' => '" . addslashes($_POST['theme']['pseudo']['margin_left']) . "'\n";
        $new_config .= ");\n\n";
        $new_config .= "\$C2PARAM['theme']['site_web'] = array(\n";
        $new_config .= "    'enabled' => " . (isset($_POST['theme']['site_web']['enabled']) ? 'true' : 'false') . ",\n";
        $new_config .= "    'text_size' => '" . addslashes($_POST['theme']['site_web']['text_size']) . "',\n";
        $new_config .= "    'color' => '" . addslashes($_POST['theme']['site_web']['color']) . "',\n";
        $new_config .= "    'margin_left' => '" . addslashes($_POST['theme']['site_web']['margin_left']) . "'\n";
        $new_config .= ");\n\n";
        $new_config .= "\$C2PARAM['theme']['commentaire'] = array(\n";
        $new_config .= "    'text_size' => '" . addslashes($_POST['theme']['commentaire']['text_size']) . "',\n";
        $new_config .= "    'color' => '" . addslashes($_POST['theme']['commentaire']['color']) . "'\n";
        $new_config .= ");\n\n";
        $new_config .= "\$C2PARAM['theme']['commentaire_field'] = array(\n";
        $new_config .= "    'text_size' => '" . addslashes($_POST['theme']['commentaire_field']['text_size']) . "',\n";
        $new_config .= "    'color' => '" . addslashes($_POST['theme']['commentaire_field']['color']) . "',\n";
        $new_config .= "    'margin_left' => '" . addslashes($_POST['theme']['commentaire_field']['margin_left']) . "'\n";
        $new_config .= ");\n\n";
        $new_config .= "\$C2PARAM['theme']['captcha'] = array(\n";
        $new_config .= "    'text_size' => '" . addslashes($_POST['theme']['captcha']['text_size']) . "',\n";
        $new_config .= "    'color' => '" . addslashes($_POST['theme']['captcha']['color']) . "',\n";
        $new_config .= "    'margin_left' => '" . addslashes($_POST['theme']['captcha']['margin_left']) . "'\n";
        $new_config .= ");\n\n";
        $new_config .= "// Cadre du formulaire\n";
        $new_config .= "\$C2PARAM['theme']['form_border'] = array(\n";
        $new_config .= "    'color' => '" . addslashes($_POST['theme']['form_border']['color']) . "'\n";
        $new_config .= ");\n\n";
        $new_config .= "\$C2PARAM['theme']['form_focus'] = array(\n";
        $new_config .= "    'border_color' => '" . addslashes($_POST['theme']['form_focus']['border_color']) . "'\n";
        $new_config .= ");\n\n";
        $new_config .= "// Boutons et liens\n";
        $new_config .= "\$C2PARAM['theme']['button_comment'] = array(\n";
        $new_config .= "    'type' => '" . addslashes($_POST['theme']['button_comment']['type']) . "',\n";
        $new_config .= "    'text_size' => '" . addslashes($_POST['theme']['button_comment']['text_size']) . "',\n";
        $new_config .= "    'bg_color' => '" . addslashes($_POST['theme']['button_comment']['bg_color']) . "',\n";
        $new_config .= "    'hover_color' => '" . addslashes($_POST['theme']['button_comment']['hover_color']) . "'\n";
        $new_config .= ");\n\n";
        $new_config .= "\$C2PARAM['theme']['button_submit'] = array(\n";
        $new_config .= "    'text_size' => '" . addslashes($_POST['theme']['button_submit']['text_size']) . "',\n";
        $new_config .= "    'bg_color' => '" . addslashes($_POST['theme']['button_submit']['bg_color']) . "',\n";
        $new_config .= "    'hover_color' => '" . addslashes($_POST['theme']['button_submit']['hover_color']) . "',\n";
        $new_config .= "    'margin_left' => '" . addslashes($_POST['theme']['button_submit']['margin_left']) . "'\n";
        $new_config .= ");\n\n";
        $new_config .= "\$C2PARAM['theme']['button_reply'] = array(\n";
        $new_config .= "    'type' => '" . addslashes($_POST['theme']['button_reply']['type']) . "',\n";
        $new_config .= "    'text_size' => '" . addslashes($_POST['theme']['button_reply']['text_size']) . "',\n";
        $new_config .= "    'bg_color' => '" . addslashes($_POST['theme']['button_reply']['bg_color']) . "',\n";
        $new_config .= "    'hover_color' => '" . addslashes($_POST['theme']['button_reply']['hover_color']) . "'\n";
        $new_config .= ");\n\n";
        $new_config .= "// Options générales des boutons\n";
        $new_config .= "\$C2PARAM['theme']['buttons'] = array(\n";
        $new_config .= "    'border_radius' => '" . addslashes($_POST['theme']['buttons']['border_radius']) . "'\n";
        $new_config .= ");\n";
        $new_config .= "\$C2PARAM['buttons_margin_top'] = '" . addslashes($_POST['buttons_margin_top']) . "';\n";
        $new_config .= "\$C2PARAM['button_submit_alignment'] = '" . addslashes($_POST['button_submit_alignment']) . "';\n\n";
        $new_config .= "// Configuration du mode clair/sombre\n";
        $new_config .= "\$C2PARAM['theme_toggle'] = array(\n";
        $new_config .= "    'alignment' => '" . addslashes($_POST['theme_toggle']['alignment']) . "',\n";
        $new_config .= "    'text_size' => '" . addslashes($_POST['theme_toggle']['text_size']) . "'\n";
        $new_config .= ");\n\n";
        $new_config .= "// Autres configurations si nécessaire\n?>";
        file_put_contents('../config.php', $new_config);

        // Sauvegarder les mots-clés spam
        if (isset($_POST['spam_keywords'])) {
            file_put_contents('../spam.txt', $_POST['spam_keywords']);
        }

        // Sauvegarder les traductions
        if (isset($_POST['translations'])) {
            // Charger d'abord les traductions existantes pour conserver toutes les langues
            $existing_translations = array();
            if (file_exists('../translations.php')) {
                include '../translations.php';
                $existing_translations = $translations;
            }
            // Mettre à jour seulement la langue sélectionnée
            $current_lang = $_POST['current_language'];
            $existing_translations[$current_lang] = $_POST['translations'];
            // Générer le code PHP pour le fichier translations.php
            $export = "<?php\n\$translations = ";
            $export .= var_export($existing_translations, true);
            $export .= ";\n?>";
            file_put_contents('../translations.php', $export);
            // Recharger les traductions dans la session courante
            $C2PARAM['translations'] = $existing_translations;
        }
        redirectWithMessage('index.php?action=config', 'Configurations sauvegardées avec succès. Redirection...');
    } elseif ($action === 'config') {
        // Afficher le formulaire de config
    } else {
        $comment_id = str_replace('..', '', $_GET['id']);
        $file = null;
        if (is_dir($C2PARAM['comments_dir'])) {
            $dirs = glob($C2PARAM['comments_dir'] . '*', GLOB_ONLYDIR);
            foreach ($dirs as $dir) {
                $potential_file = $dir . '/' . $comment_id . '.json';
                if (file_exists($potential_file)) {
                    $file = $potential_file;
                    break;
                }
            }
        }
        if ($file && file_exists($file)) {
            $comment = json_decode(file_get_contents($file), true);
            if ($action === 'validate') {
                $comment['validated'] = true;
                file_put_contents($file, json_encode($comment, JSON_PRETTY_PRINT));
                redirectWithMessage('index.php?page_id=' . urlencode($comment['page_id']), 'Commentaire validé. Redirection...');
            } elseif ($action === 'delete') {
                unlink($file);
                redirectWithMessage('index.php?page_id=' . urlencode($comment['page_id']), 'Commentaire supprimé. Redirection...');
            } elseif ($action === 'edit' && $_SERVER['REQUEST_METHOD'] === 'POST') {
                $comment['pseudo'] = htmlspecialchars($_POST['pseudo']);
                $comment['site_web'] = htmlspecialchars($_POST['site_web']);
                $comment['commentaire'] = htmlspecialchars($_POST['commentaire']);
                file_put_contents($file, json_encode($comment, JSON_PRETTY_PRINT));
                redirectWithMessage('index.php?page_id=' . urlencode($comment['page_id']), 'Commentaire modifié. Redirection...');
            }
        }
    }
}

$page_id_selected = isset($_GET['page_id']) ? $_GET['page_id'] : null;
$comments = listComments($page_id_selected);
$page_ids = listPageIds();
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Administration des Commentaires</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background-color: #f4f4f4;
        }
        h1, h2, h3 {
            color: #333;
        }
        h2 {
            margin-top: 40px;
            border-bottom: 2px solid #ddd;
            padding-bottom: 10px;
        }
        h3 {
            margin-top: 30px;
            color: #555;
        }
        p {
            margin-bottom: 20px;
        }
        ul {
            margin-bottom: 20px;
        }
        li {
            margin-bottom: 5px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        form {
            background-color: white;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 10px;
            font-weight: bold;
        }
        input[type="text"], input[type="password"], input[type="email"], input[type="number"], input[type="url"], textarea, select {
            width: 100%;
            padding: 8px;
            margin-bottom: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
            box-sizing: border-box;
        }
        textarea {
            height: 80px;
        }
        input[type="checkbox"] {
            width: auto;
            margin-right: 10px;
        }
        button {
            background-color: #4CAF50;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        button:hover {
            background-color: #45a049;
        }
        .section {
            margin-bottom: 30px;
            border: 1px solid #ddd;
            padding: 15px;
            background-color: #f9f9f9;
        }
        textarea[readonly] {
            background-color: #f9f9f9;
            font-family: monospace;
        }

        /* Tabs */
        .tabs {
            display: flex;
            margin-bottom: 20px;
        }
        .tab-button {
            background-color: #ddd;
            border: none;
            padding: 10px 20px;
            cursor: pointer;
            font-size: 16px;
            border-radius: 5px 5px 0 0;
            margin-right: 5px;
            color: #333;
        }
        .tab-button.active {
            background-color: white;
            border-bottom: 2px solid #4CAF50;
        }
        .tab-content {
            display: none;
            padding: 20px;
            background-color: white;
            border: 1px solid #ddd;
            border-radius: 0 5px 5px 5px;
        }
        .tab-content.active {
            display: block;
        }

        /* Styles responsive */
        @media (max-width: 768px) {
            body {
                margin: 10px;
                padding: 0;
            }
            
            h1 {
                font-size: 24px;
            }
            
            h2 {
                font-size: 20px;
                margin-top: 20px;
            }
            
            h3 {
                font-size: 18px;
                margin-top: 20px;
            }
            
            h4, h5 {
                font-size: 16px;
            }
            
            nav {
                display: flex;
                flex-wrap: wrap;
                gap: 10px;
                padding: 10px 0;
            }
            
            nav a {
                font-size: 14px;
                margin: 5px 0 !important;
            }
            
            .tabs {
                flex-wrap: wrap;
            }
            
            .tab-button {
                flex: 1 1 45%;
                text-align: center;
                padding: 8px 10px;
                font-size: 14px;
                margin-bottom: 5px;
            }
            
            .section {
                padding: 10px;
            }
            
            table {
                display: block;
                overflow-x: auto;
                white-space: nowrap;
            }
            
            th, td {
                min-width: 120px;
                font-size: 13px;
                padding: 6px 4px;
            }
            
            form {
                padding: 15px 10px;
            }
            
            label {
                font-size: 14px;
            }
            
            input[type="text"], input[type="password"], input[type="email"], 
            input[type="number"], input[type="url"], textarea, select {
                font-size: 14px;
                padding: 6px;
            }
            
            button {
                width: 100%;
                margin-top: 10px;
                font-size: 14px;
                padding: 12px;
            }
            
            #code-generator label {
                margin-bottom: 5px;
            }
            
            #generated_code {
                width: 100%;
                font-size: 12px;
            }
            
            .tab-content {
                padding: 15px 10px;
            }
            
            .tab-content h4, .tab-content h5 {
                margin-top: 15px;
                margin-bottom: 10px;
            }
        }

        @media (max-width: 480px) {
            body {
                font-size: 14px;
            }
            
            h1 {
                font-size: 20px;
            }
            
            h2 {
                font-size: 18px;
            }
            
            .tab-button {
                flex: 1 1 100%;
                font-size: 13px;
            }
            
            th, td {
                font-size: 12px;
                min-width: 100px;
            }
            
            #smtp_fields {
                padding: 10px;
                background: #f5f5f5;
                border-radius: 4px;
            }
        }
    </style>
</head>
<body>
<nav style="margin-bottom: 20px; border-bottom: 1px solid #ccc; padding-bottom: 10px;">
    <a href="index.php" style="margin-right: 20px; <?php echo !isset($_GET['action']) && !isset($_GET['page_id']) ? 'font-weight: bold;' : ''; ?>">Accueil</a>
    <?php if (isset($_GET['page_id'])): ?>
    <span style="margin-right: 20px;">></span>
    <a href="?page_id=<?php echo urlencode($_GET['page_id']); ?>" style="font-weight: bold;">Afficher les commentaires</a>
    <?php endif; ?>
    <a href="?action=config" style="margin-left: 20px; <?php echo isset($_GET['action']) && $_GET['action'] === 'config' ? 'font-weight: bold;' : ''; ?>">Configurations</a>
    <a href="?logout=1" style="margin-left: 20px; color: red;">Déconnexion</a>
</nav>

<?php if (!isset($_GET['action']) && !isset($_GET['page_id'])): ?>
<h1>Administration des Commentaires</h1>
<div class="section">
    <p><a href="?action=config">Modifier les Configurations</a></p>
</div>
<div class="section">
    <h2>Pages avec commentaires</h2>
    <ul>
        <?php foreach ($page_ids as $pid): ?>
        <li><a href="?page_id=<?php echo urlencode($pid); ?>"><?php echo htmlspecialchars($pid); ?></a></li>
        <?php endforeach; ?>
    </ul>
</div>
<?php endif; ?>
    <?php if ($page_id_selected): ?>
    <div class="section">
        <h1>Commentaires pour la page : <?php echo htmlspecialchars($page_id_selected); ?></h1>
        <p><a href="index.php">Retour à la liste des pages</a></p>
        <table>
            <tr>
                <th>ID Commentaire</th>
                <th>Pseudo</th>
                <th>Commentaire</th>
                <th>Validé</th>
                <th>Actions</th>
            </tr>
            <?php foreach ($comments as $c): ?>
            <tr>
                <td><?php echo $c['id']; ?></td>
                <td><?php echo $c['pseudo']; ?></td>
                <td><?php echo nl2br($c['commentaire']); ?></td>
                <td><?php echo $c['validated'] ? 'Oui' : 'Non'; ?></td>
                <td>
                    <?php if (!$c['validated']): ?>
                    <a href="?page_id=<?php echo urlencode($page_id_selected); ?>&action=validate&id=<?php echo $c['id']; ?>">Valider</a>
                    <?php endif; ?>
                    <a href="?page_id=<?php echo urlencode($page_id_selected); ?>&action=edit&id=<?php echo $c['id']; ?>">Modifier</a>
                    <a href="?page_id=<?php echo urlencode($page_id_selected); ?>&action=delete&id=<?php echo $c['id']; ?>" onclick="return confirm('Supprimer ?')">Supprimer</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
    <?php endif; ?>
    <?php if (isset($_GET['action']) && $_GET['action'] === 'edit' && isset($comment)): ?>
    <div class="section">
        <h1>Modifier le commentaire</h1>
        <form method="post">
            <label>Pseudo :<br> <input type="text" name="pseudo" value="<?php echo $comment['pseudo']; ?>" required></label><br>
            <label>Site Web :<br> <input type="url" name="site_web" value="<?php echo $comment['site_web']; ?>"></label><br>
            <label>Commentaire :<br> <textarea name="commentaire" required><?php echo $comment['commentaire']; ?></textarea></label><br>
            <button type="submit">Sauvegarder</button>
        </form>
    </div>
    <?php endif; ?>

    <?php if (isset($_GET['action']) && $_GET['action'] === 'config'): ?>
        <h1>Configurations</h1>
        <div class="section">
            <h3>Configurations</h3>
            <div class="tabs">
                <button type="button" class="tab-button active" onclick="showTab('general')">Général</button>
                <button type="button" class="tab-button" onclick="showTab('antispam')">Anti-Spam</button>
                <button type="button" class="tab-button" onclick="showTab('theme')">Thème</button>
                <button type="button" class="tab-button" onclick="showTab('translations')">Traductions</button>
            </div>
            <form method="post">
                <div id="general" class="tab-content active">
                    <h4>Code PHP pour WebAccappella</h4>
                    <p>Copiez ce code dans vos pages WebAccappella pour afficher le système de commentaires :</p>
                    <div id="code-generator">
                        <label>Chemin d'installation (relatif depuis la page WebAccappella) :<br>
                        <input type="text" id="install_path" name="default_install_path" placeholder="ex: ./systeme-commentaires" value="<?php echo htmlspecialchars($C2PARAM['default_install_path'] ?? './systeme-commentaires'); ?>" oninput="updateCode(false)"></label>
                        <label>ID de la page (page_id) :<br>
                        <input type="text" id="page_id_code" name="default_page_id" placeholder="ex: page_1" value="<?php echo htmlspecialchars($C2PARAM['default_page_id'] ?? 'page_1'); ?>" oninput="updateCode(false)"></label>
                        <textarea id="generated_code" style="height:95px" readonly><?php
    $install_path = htmlspecialchars($C2PARAM['default_install_path'] ?? './systeme-commentaires');
    $page_id_code = htmlspecialchars($C2PARAM['default_page_id'] ?? 'page_1');
    echo "<?php\n";
    echo "include_once realpath('" . $install_path . "/config.php');\n";
    echo "include_once realpath('" . $install_path . "/comments.php');\n";
    echo "echo displayCommentSystem(\"" . $page_id_code . "\");\n";
    echo "?>";
    ?></textarea><br>
                        <button type="button" onclick="updateCode(true)">Mettre à jour le code</button>
                    </div>
                    <script>
                        function updateCode(soumettre=false) {
                            const installPath = document.getElementById('install_path').value;
                            const pageId = document.getElementById('page_id_code').value;
                            const code = `<\?php
include_once realpath('${installPath}/config.php');
include_once realpath('${installPath}/comments.php');
echo displayCommentSystem("${pageId}");
?>`;
                            document.getElementById('generated_code').value = code;
                            if(soumettre) {
                                // Soumettre le formulaire pour enregistrer les valeurs
                                document.querySelector('form').submit();
                            }
                        }
                        
                        // Initialiser le code au chargement de la page
                        document.addEventListener('DOMContentLoaded', function() {
                            updateCode(false);
                        });
                    </script>

                    <h4>Paramètres Généraux</h4>

                    <label>Mode de validation :<br>
                    <select name="validation_mode">
                        <option value="direct" <?php echo $C2PARAM['validation_mode'] === 'direct' ? 'selected' : ''; ?>>Direct</option>
                        <option value="ftp" <?php echo $C2PARAM['validation_mode'] === 'ftp' ? 'selected' : ''; ?>>À Valider</option>
                    </select></label>

                    <label>Mot de passe admin :<br> <input type="text" name="admin_password" value="<?php echo htmlspecialchars($C2PARAM['admin_password']); ?>" required></label>

                    <label>Email admin :<br> <input type="email" name="admin_email" value="<?php echo htmlspecialchars($C2PARAM['admin_email']); ?>" required></label>

                    <label><input type="checkbox" name="use_smtp" id="use_smtp" <?php echo $C2PARAM['use_smtp'] ? 'checked' : ''; ?>> Utiliser SMTP</label>

                    <div id="smtp_fields" style="display: <?php echo $C2PARAM['use_smtp'] ? 'block' : 'none'; ?>;">
                        <label>SMTP Host :<br> <input type="text" name="smtp_host" value="<?php echo htmlspecialchars($C2PARAM['smtp_host']); ?>"></label>

                        <label>SMTP Username :<br> <input type="text" name="smtp_username" value="<?php echo htmlspecialchars($C2PARAM['smtp_username']); ?>"></label>

                        <label>SMTP Password :<br> <input type="text" name="smtp_password" value="<?php echo htmlspecialchars($C2PARAM['smtp_password']); ?>"></label>

                        <label>SMTP Port :<br> <input type="number" name="smtp_port" value="<?php echo intval($C2PARAM['smtp_port']); ?>"></label>

                        <label>SMTP Secure :<br>
                        <select name="smtp_secure">
                            <option value="tls" <?php echo $C2PARAM['smtp_secure'] === 'tls' ? 'selected' : ''; ?>>TLS</option>
                            <option value="ssl" <?php echo $C2PARAM['smtp_secure'] === 'ssl' ? 'selected' : ''; ?>>SSL</option>
                        </select></label>
                    </div>

                    <label><input type="checkbox" name="recent_first" <?php echo $C2PARAM['recent_first'] ? 'checked' : ''; ?>> Commentaires récents en premier</label>

                    <label><input type="checkbox" name="afficher_boutons_repondre"<?php echo $C2PARAM['afficher_boutons_repondre'] ? ' checked' : ''; ?>> Afficher les boutons "Répondre"</label>

                    <label>Profondeur maximale des réponses (0-10) :<br> <input type="number" name="max_reply_depth" min="0" max="10" value="<?php echo intval($C2PARAM['max_reply_depth']); ?>" required></label>
                </div>
                <div id="antispam" class="tab-content">
                    <h4>Anti-Spam</h4>
                    <label>Type de Captcha :<br>
                    <select name="captcha_type">
                        <option value="none" <?php echo $C2PARAM['captcha_type'] === 'none' ? 'selected' : ''; ?>>Sans Captcha</option>
                        <option value="basic" <?php echo $C2PARAM['captcha_type'] === 'basic' ? 'selected' : ''; ?>>Captcha Basique</option>
                        <option value="hcaptcha" <?php echo $C2PARAM['captcha_type'] === 'hcaptcha' ? 'selected' : ''; ?>>Hcaptcha</option>
                    </select></label>

                    <label>Taille Hcaptcha :<br>
                    <select name="hcaptcha_size">
                        <option value="normal" <?php echo ($C2PARAM['hcaptcha_size'] ?? 'normal') === 'normal' ? 'selected' : ''; ?>>Normal</option>
                        <option value="compact" <?php echo ($C2PARAM['hcaptcha_size'] ?? 'normal') === 'compact' ? 'selected' : ''; ?>>Compact</option>
                    </select></label>

                    <label>Clé Site Hcaptcha :<br> <input type="text" name="hcaptcha_sitekey" value="<?php echo htmlspecialchars($C2PARAM['hcaptcha_sitekey']); ?>"></label>

                    <label>Clé Secrète Hcaptcha :<br> <input type="text" name="hcaptcha_secretkey" value="<?php echo htmlspecialchars($C2PARAM['hcaptcha_secretkey']); ?>"></label>

                    <label>Temps minimum pour remplir le formulaire (secondes) :<br> <input type="number" name="min_form_time" min="0" value="<?php echo intval($C2PARAM['min_form_time']); ?>" required></label>

                    <label>Limite de caractères par commentaire :<br> <input type="number" name="max_comment_length" min="0" value="<?php echo intval($C2PARAM['max_comment_length'] ?? 1000); ?>" required></label>

                    <label>Commentaires par page :<br> <input type="number" name="comments_per_page" min="1" value="<?php echo intval($C2PARAM['comments_per_page'] ?? 10); ?>" required></label>

                    <label>Mode d'affichage :<br>
                    <select name="display_mode">
                        <option value="add_and_view" <?php echo ($C2PARAM['display_mode'] ?? 'add_and_view') === 'add_and_view' ? 'selected' : ''; ?>>Ajouter un commentaire + Voir les commentaires (avec liste des commentaires)</option>
                        <option value="view_only" <?php echo ($C2PARAM['display_mode'] ?? 'add_and_view') === 'view_only' ? 'selected' : ''; ?>>Voir le bouton commentaire seulement (sans liste des commentaires)</option>
                    </select></label>

                    <label>Mots-clés Spam (un par ligne) :<br> <textarea name="spam_keywords" rows="5" cols="50"><?php echo htmlspecialchars(file_exists('../spam.txt') ? file_get_contents('../spam.txt') : ''); ?></textarea></label>
                </div>
                <div id="theme" class="tab-content">
                    <h4>Personnalisation du Thème</h4>

                    <h5>Éléments du Formulaire</h5>
                    <label>Taille texte Formulaire :<br> <input type="text" name="theme[form][text_size]" value="<?php echo htmlspecialchars($C2PARAM['theme']['form']['text_size'] ?? '24px'); ?>"></label>
                    <label>Couleur Formulaire :<br> <input type="color" id="form_color" name="theme[form][color]" value="<?php echo htmlspecialchars($C2PARAM['theme']['form']['color'] ?? '#2F5496'); ?>"> <button type="button" onclick="toggleInputType('form_color')">Switch</button></label>

                    <label>Taille texte Pseudo :<br> <input type="text" name="theme[pseudo][text_size]" value="<?php echo htmlspecialchars($C2PARAM['theme']['pseudo']['text_size'] ?? '16px'); ?>"></label>
                    <label>Couleur Pseudo :<br> <input type="color" id="pseudo_color" name="theme[pseudo][color]" value="<?php echo htmlspecialchars($C2PARAM['theme']['pseudo']['color'] ?? '#2F5496'); ?>"> <button type="button" onclick="toggleInputType('pseudo_color')">Switch</button></label>
                    <label>Marge gauche Pseudo :<br> <input type="text" name="theme[pseudo][margin_left]" value="<?php echo htmlspecialchars($C2PARAM['theme']['pseudo']['margin_left'] ?? '10px'); ?>"></label>

                    <label><input type="checkbox" name="theme[site_web][enabled]" <?php echo isset($C2PARAM['theme']['site_web']['enabled']) && $C2PARAM['theme']['site_web']['enabled'] ? 'checked' : ''; ?>> Activer le champ Site Web</label>
                    <label>Taille texte Site Web :<br> <input type="text" name="theme[site_web][text_size]" value="<?php echo htmlspecialchars($C2PARAM['theme']['site_web']['text_size'] ?? '16px'); ?>"></label>
                    <label>Couleur Site Web :<br> <input type="color" id="site_web_color" name="theme[site_web][color]" value="<?php echo htmlspecialchars($C2PARAM['theme']['site_web']['color'] ?? '#2F5496'); ?>"> <button type="button" onclick="toggleInputType('site_web_color')">Switch</button></label>
                    <label>Marge gauche Site Web :<br> <input type="text" name="theme[site_web][margin_left]" value="<?php echo htmlspecialchars($C2PARAM['theme']['site_web']['margin_left'] ?? '10px'); ?>"></label>

                    <label>Taille texte Commentaire :<br> <input type="text" name="theme[commentaire][text_size]" value="<?php echo htmlspecialchars($C2PARAM['theme']['commentaire']['text_size'] ?? '24px'); ?>"></label>
                    <label>Couleur Commentaire :<br> <input type="color" id="commentaire_color" name="theme[commentaire][color]" value="<?php echo htmlspecialchars($C2PARAM['theme']['commentaire']['color'] ?? '#2F5496'); ?>"> <button type="button" onclick="toggleInputType('commentaire_color')">Switch</button></label>

                    <label>Taille texte Commentaire (textarea) :<br> <input type="text" name="theme[commentaire_field][text_size]" value="<?php echo htmlspecialchars($C2PARAM['theme']['commentaire_field']['text_size'] ?? '13px'); ?>"></label>
                    <label>Couleur Commentaire (textarea) :<br> <input type="color" id="commentaire_field_color" name="theme[commentaire_field][color]" value="<?php echo htmlspecialchars($C2PARAM['theme']['commentaire_field']['color'] ?? '#2F5496'); ?>"> <button type="button" onclick="toggleInputType('commentaire_field_color')">Switch</button></label>
                    <label>Marge gauche Commentaire (textarea) :<br> <input type="text" name="theme[commentaire_field][margin_left]" value="<?php echo htmlspecialchars($C2PARAM['theme']['commentaire_field']['margin_left'] ?? '10px'); ?>"></label>

                    <label>Taille texte Captcha :<br> <input type="text" name="theme[captcha][text_size]" value="<?php echo htmlspecialchars($C2PARAM['theme']['captcha']['text_size'] ?? '24px'); ?>"></label>
                    <label>Couleur Captcha :<br> <input type="color" id="captcha_color" name="theme[captcha][color]" value="<?php echo htmlspecialchars($C2PARAM['theme']['captcha']['color'] ?? '#2F5496'); ?>"> <button type="button" onclick="toggleInputType('captcha_color')">Switch</button></label>
                    <label>Marge gauche Captcha :<br> <input type="text" name="theme[captcha][margin_left]" value="<?php echo htmlspecialchars($C2PARAM['theme']['captcha']['margin_left'] ?? '10px'); ?>"></label>

                    <h5>Commentaires longs</h5>
                    <label>Nombre de lignes avant troncature :<br> <input type="number" name="comment_truncate_lines" min="1" value="<?php echo intval($C2PARAM['comment_truncate_lines'] ?? 3); ?>"></label>
                    <label>Couleur du bouton "Plus" :<br> <input type="color" id="read_more_color" name="read_more_color" value="<?php echo htmlspecialchars($C2PARAM['read_more_color'] ?? '#007bff'); ?>"> <button type="button" onclick="toggleInputType('read_more_color')">Switch</button></label>
                    <label>Taille du bouton "Plus" :<br> <input type="text" name="read_more_size" value="<?php echo htmlspecialchars($C2PARAM['read_more_size'] ?? '14px'); ?>"></label>

                    <h5>Cadre du Formulaire</h5>
                    <label>Couleur bordure formulaire :<br> <input type="color" id="form_border_color" name="theme[form_border][color]" value="<?php echo htmlspecialchars($C2PARAM['theme']['form_border']['color'] ?? '#2F5496'); ?>"> <button type="button" onclick="toggleInputType('form_border_color')">Switch</button></label>
                    <label>Couleur bordure au focus :<br> <input type="color" id="form_focus_border_color" name="theme[form_focus][border_color]" value="<?php echo htmlspecialchars($C2PARAM['theme']['form_focus']['border_color'] ?? '#2F5496'); ?>"> <button type="button" onclick="toggleInputType('form_focus_border_color')">Switch</button></label>

                    <h5>Boutons et Liens</h5>
                    <label>Type bouton Commentaire :<br>
                    <select name="theme[button_comment][type]">
                        <option value="button" <?php echo ($C2PARAM['theme']['button_comment']['type'] ?? 'button') === 'button' ? 'selected' : ''; ?>>Bouton</option>
                        <option value="link" <?php echo ($C2PARAM['theme']['button_comment']['type'] ?? 'button') === 'link' ? 'selected' : ''; ?>>Lien</option>
                    </select></label>
                    <label>Nom bouton Commentaire :<br> <input type="text" name="theme[button_comment][name]" value="<?php echo htmlspecialchars($C2PARAM['theme']['button_comment']['name'] ?? 'Commentaire'); ?>"></label>
                    <label>Taille texte bouton Commentaire :<br> <input type="text" name="theme[button_comment][text_size]" value="<?php echo htmlspecialchars($C2PARAM['theme']['button_comment']['text_size'] ?? '16px'); ?>"></label>
                    <label>Couleur fond bouton Commentaire :<br> <input type="color" id="button_comment_bg_color" name="theme[button_comment][bg_color]" value="<?php echo htmlspecialchars($C2PARAM['theme']['button_comment']['bg_color'] ?? '#2F5496'); ?>"> <button type="button" onclick="toggleInputType('button_comment_bg_color')">Switch</button></label>
                    <label>Couleur survol bouton Commentaire :<br> <input type="color" id="button_comment_hover_color" name="theme[button_comment][hover_color]" value="<?php echo htmlspecialchars($C2PARAM['theme']['button_comment']['hover_color'] ?? '#4040C0'); ?>"> <button type="button" onclick="toggleInputType('button_comment_hover_color')">Switch</button></label>

                    <label>Nom bouton Soumettre :<br> <input type="text" name="theme[button_submit][name]" value="<?php echo htmlspecialchars($C2PARAM['theme']['button_submit']['name'] ?? 'Soumettre'); ?>"></label>
                    <label>Taille texte bouton Soumettre :<br> <input type="text" name="theme[button_submit][text_size]" value="<?php echo htmlspecialchars($C2PARAM['theme']['button_submit']['text_size'] ?? '13px'); ?>"></label>
                    <label>Couleur fond bouton Soumettre :<br> <input type="color" id="button_submit_bg_color" name="theme[button_submit][bg_color]" value="<?php echo htmlspecialchars($C2PARAM['theme']['button_submit']['bg_color'] ?? '#2F5496'); ?>"> <button type="button" onclick="toggleInputType('button_submit_bg_color')">Switch</button></label>
                    <label>Couleur survol bouton Soumettre :<br> <input type="color" id="button_submit_hover_color" name="theme[button_submit][hover_color]" value="<?php echo htmlspecialchars($C2PARAM['theme']['button_submit']['hover_color'] ?? '#4040C0'); ?>"> <button type="button" onclick="toggleInputType('button_submit_hover_color')">Switch</button></label>
                    <label>Marge gauche bouton Soumettre :<br> <input type="text" name="theme[button_submit][margin_left]" value="<?php echo htmlspecialchars($C2PARAM['theme']['button_submit']['margin_left'] ?? '10px'); ?>"></label>
                    <label>Alignement bouton Soumettre :<br>
                    <select name="button_submit_alignment">
                        <option value="left" <?php echo ($C2PARAM['button_submit_alignment'] ?? 'left') === 'left' ? 'selected' : ''; ?>>Gauche</option>
                        <option value="center" <?php echo ($C2PARAM['button_submit_alignment'] ?? 'left') === 'center' ? 'selected' : ''; ?>>Centre</option>
                        <option value="right" <?php echo ($C2PARAM['button_submit_alignment'] ?? 'left') === 'right' ? 'selected' : ''; ?>>Droite</option>
                    </select></label>

                    <label>Type bouton Répondre :<br>
                    <select name="theme[button_reply][type]">
                        <option value="button" <?php echo ($C2PARAM['theme']['button_reply']['type'] ?? 'button') === 'button' ? 'selected' : ''; ?>>Bouton</option>
                        <option value="link" <?php echo ($C2PARAM['theme']['button_reply']['type'] ?? 'button') === 'link' ? 'selected' : ''; ?>>Lien</option>
                    </select></label>
                    <label>Nom bouton Répondre :<br> <input type="text" name="theme[button_reply][name]" value="<?php echo htmlspecialchars($C2PARAM['theme']['button_reply']['name'] ?? 'Répondre'); ?>"></label>
                    <label>Taille texte bouton Répondre :<br> <input type="text" name="theme[button_reply][text_size]" value="<?php echo htmlspecialchars($C2PARAM['theme']['button_reply']['text_size'] ?? '16px'); ?>"></label>
                    <label>Couleur fond bouton Répondre :<br> <input type="color" id="button_reply_bg_color" name="theme[button_reply][bg_color]" value="<?php echo htmlspecialchars($C2PARAM['theme']['button_reply']['bg_color'] ?? '#2F5496'); ?>"> <button type="button" onclick="toggleInputType('button_reply_bg_color')">Switch</button></label>
                    <label>Couleur survol bouton Répondre :<br> <input type="color" id="button_reply_hover_color" name="theme[button_reply][hover_color]" value="<?php echo htmlspecialchars($C2PARAM['theme']['button_reply']['hover_color'] ?? '#4040C0'); ?>"> <button type="button" onclick="toggleInputType('button_reply_hover_color')">Switch</button></label>

                    <label>Arrondis des boutons :<br> <input type="text" name="theme[buttons][border_radius]" value="<?php echo htmlspecialchars($C2PARAM['theme']['buttons']['border_radius'] ?? '4px'); ?>"></label>

                    <label>Marge en hauteur des boutons :<br> <input type="text" name="buttons_margin_top" value="<?php echo htmlspecialchars($C2PARAM['buttons_margin_top'] ?? '10px'); ?>"></label>

                    <h5>Mode Clair/Sombre</h5>
                    <label>Alignement des icônes :<br>
                    <select name="theme_toggle[alignment]">
                        <option value="left" <?php echo ($C2PARAM['theme_toggle']['alignment'] ?? 'right') === 'left' ? 'selected' : ''; ?>>Gauche</option>
                        <option value="center" <?php echo ($C2PARAM['theme_toggle']['alignment'] ?? 'right') === 'center' ? 'selected' : ''; ?>>Centre</option>
                        <option value="right" <?php echo ($C2PARAM['theme_toggle']['alignment'] ?? 'right') === 'right' ? 'selected' : ''; ?>>Droite</option>
                    </select></label>
                    <label>Taille du texte :<br> <input type="text" name="theme_toggle[text_size]" value="<?php echo htmlspecialchars($C2PARAM['theme_toggle']['text_size'] ?? '24px'); ?>"></label>

                    <button type="button" onclick="resetTheme()">Réinitialiser le thème</button><br><br>
                </div>
                <div id="translations" class="tab-content">
                    <h4>Gestion des Traductions</h4>
                    
                    <!-- Section pour ajouter une nouvelle langue -->
                    <div class="section" style="background-color: #e8f5e9;">
                        <h5>Ajouter une nouvelle langue</h5>
                        <label>Code de la langue (ex: de, es, it) :<br>
                        <input type="text" id="new_lang_code" pattern="[a-z]{2}" title="Code langue en 2 lettres minuscules" required style="width: 100px;"></label>
                        <button type="button" onclick="addNewLanguage()" style="vertical-align: middle;">Ajouter</button>
                        <p id="lang_message" style="margin-top: 10px;"></p>
                    </div>
                    
                    <label>Langue actuelle :<br>
                    <select name="current_language" id="current_language">
                        <?php foreach (array_keys($C2PARAM['translations']) as $lang): ?>
                        <option value="<?php echo $lang; ?>" <?php echo $C2PARAM['current_language'] === $lang ? 'selected' : ''; ?>><?php echo strtoupper($lang); ?></option>
                        <?php endforeach; ?>
                    </select></label>
                    
                    <h5 style="margin-top: 20px; color: #2196F3;">Traductions pour le script (affichage sur le site)</h5>
                    <?php
                    $current_translations = $C2PARAM['translations'][$C2PARAM['current_language']];
                    $admin_translation_keys = array('administration', 'admin_login', 'password_label', 'login_button', 'home', 'show_comments', 'edit_config', 'pages_with_comments', 'comments_for_page', 'back_to_list', 'comment_id', 'comment_text', 'validated', 'actions', 'validate', 'edit', 'delete', 'delete_confirm', 'edit_comment', 'pseudo_colon', 'site_web_colon', 'commentaire_colon', 'save', 'configurations', 'config_saved', 'php_code_for_webaccappella', 'copy_code_instruction', 'install_path_label', 'install_path_example', 'page_id_label', 'page_id_example', 'update_code', 'validation_mode', 'direct', 'to_validate', 'admin_password', 'admin_email', 'use_smtp', 'smtp_host', 'smtp_username', 'smtp_password', 'smtp_port', 'smtp_secure', 'tls', 'ssl', 'recent_first', 'show_reply_buttons', 'max_reply_depth', 'anti_spam', 'captcha_type', 'no_captcha', 'basic_captcha', 'hcaptcha', 'hcaptcha_site_key', 'hcaptcha_secret_key', 'min_form_time', 'max_comment_length', 'comments_per_page', 'display_mode', 'add_and_view', 'view_only', 'spam_keywords', 'theme_customization', 'form_elements', 'form_label_name', 'form_text_size', 'form_color', 'switch', 'pseudo_label_name', 'pseudo_text_size', 'pseudo_color', 'pseudo_margin_left', 'enable_site_web', 'site_web_label_name', 'site_web_text_size', 'site_web_color', 'site_web_margin_left', 'commentaire_label_name', 'commentaire_text_size', 'commentaire_color', 'commentaire_field_label_name', 'commentaire_field_text_size', 'commentaire_field_color', 'commentaire_field_margin_left', 'captcha_label_name', 'captcha_text_size', 'captcha_color', 'captcha_margin_left', 'long_comments', 'truncate_lines', 'read_more_text_label', 'read_more_color', 'read_more_size', 'form_frame', 'form_border_color', 'form_focus_border_color', 'buttons_and_links', 'button_comment_type', 'button', 'link', 'button_comment_name_label', 'button_comment_text_size', 'button_comment_bg_color', 'button_comment_hover_color', 'button_submit_name_label', 'button_submit_text_size', 'button_submit_bg_color', 'button_submit_hover_color', 'button_submit_margin_left', 'button_submit_alignment', 'left', 'center', 'right', 'button_reply_type', 'button_reply_name_label', 'button_reply_text_size', 'button_reply_bg_color', 'button_reply_hover_color', 'buttons_border_radius', 'buttons_margin_top', 'reset_theme', 'save_config', 'yes', 'no');
                    $script_translations = array_diff_key($current_translations, array_flip($admin_translation_keys));
                    foreach ($script_translations as $key => $value): ?>
                    <label><?php echo htmlspecialchars($key); ?> :<br> <input type="text" name="translations[<?php echo $key; ?>]" value="<?php echo htmlspecialchars($value); ?>" style="width: 100%;"></label>
                    <?php endforeach; ?>
                    
                    <hr style="margin: 20px 0; border: 1px solid #ddd;">
                    <h5 style="color: #FF9800;">Traductions pour l'administration</h5>
                    <?php foreach ($current_translations as $key => $value): ?>
                    <?php if (in_array($key, $admin_translation_keys)): ?>
                    <label><?php echo htmlspecialchars($key); ?> :<br> <input type="text" name="translations[<?php echo $key; ?>]" value="<?php echo htmlspecialchars($value); ?>" style="width: 100%;"></label>
                    <?php endif; ?>
                    <?php endforeach; ?>
                </div>

                <button type="submit">Sauvegarder les Configurations</button>
            </form>
        </div>
        <script>
            function toggleInputType(id) {
                const input = document.getElementById(id);
                if (input.type === 'color') {
                    input.type = 'text';
                    input.placeholder = '#RRGGBB';
                } else {
                    input.type = 'color';
                }
            }

            function resetTheme() {
                // Valeurs par défaut pour le thème
                document.querySelector('input[name="theme[form][text_size]"]').value = '24px';
                document.querySelector('input[name="theme[form][color]"]').value = '#2F5496';

                document.querySelector('input[name="theme[pseudo][text_size]"]').value = '16px';
                document.querySelector('input[name="theme[pseudo][color]"]').value = '#2F5496';
                document.querySelector('input[name="theme[pseudo][margin_left]"]').value = '10px';

                document.querySelector('input[name="theme[site_web][enabled]"]').checked = true;
                document.querySelector('input[name="theme[site_web][text_size]"]').value = '16px';
                document.querySelector('input[name="theme[site_web][color]"]').value = '#2F5496';
                document.querySelector('input[name="theme[site_web][margin_left]"]').value = '10px';

                document.querySelector('input[name="theme[commentaire][text_size]"]').value = '24px';
                document.querySelector('input[name="theme[commentaire][color]"]').value = '#2F5496';

                document.querySelector('input[name="theme[commentaire_field][text_size]"]').value = '13px';
                document.querySelector('input[name="theme[commentaire_field][color]"]').value = '#2F5496';
                document.querySelector('input[name="theme[commentaire_field][margin_left]"]').value = '10px';

                document.querySelector('input[name="theme[captcha][text_size]"]').value = '24px';
                document.querySelector('input[name="theme[captcha][color]"]').value = '#2F5496';
                document.querySelector('input[name="theme[captcha][margin_left]"]').value = '10px';

                document.querySelector('input[name="theme[form_border][color]"]').value = '#2F5496';
                document.querySelector('input[name="theme[form_focus][border_color]"]').value = '#2F5496';

                document.querySelector('select[name="theme[button_comment][type]"]').value = 'button';
                document.querySelector('input[name="theme[button_comment][text_size]"]').value = '16px';
                document.querySelector('input[name="theme[button_comment][bg_color]"]').value = '#2F5496';
                document.querySelector('input[name="theme[button_comment][hover_color]"]').value = '#4040C0';

                document.querySelector('input[name="theme[button_submit][text_size]"]').value = '13px';
                document.querySelector('input[name="theme[button_submit][bg_color]"]').value = '#2F5496';
                document.querySelector('input[name="theme[button_submit][hover_color]"]').value = '#4040C0';
                document.querySelector('input[name="theme[button_submit][margin_left]"]').value = '10px';

                document.querySelector('select[name="theme[button_reply][type]"]').value = 'button';
                document.querySelector('input[name="theme[button_reply][text_size]"]').value = '16px';
                document.querySelector('input[name="theme[button_reply][bg_color]"]').value = '#2F5496';
                document.querySelector('input[name="theme[button_reply][hover_color]"]').value = '#4040C0';

                document.querySelector('input[name="theme[buttons][border_radius]"]').value = '4px';

                document.querySelector('input[name="buttons_margin_top"]').value = '10px';

                document.querySelector('select[name="button_submit_alignment"]').value = 'left';
            }

            // Gestion de l'affichage des champs SMTP
            document.getElementById('use_smtp').addEventListener('change', function() {
                const smtpFields = document.getElementById('smtp_fields');
                if (this.checked) {
                    smtpFields.style.display = 'block';
                } else {
                    smtpFields.style.display = 'none';
                }
            });

            // Gestion du changement de langue pour les traductions
            document.getElementById('current_language').addEventListener('change', function() {
                const lang = this.value;
                const translations = <?php echo json_encode($C2PARAM['translations']); ?>;
                if (translations[lang]) {
                    for (const key in translations[lang]) {
                        const input = document.querySelector(`input[name="translations[${key}]"]`);
                        if (input) {
                            input.value = translations[lang][key];
                        }
                    }
                }
            });

            // Gestion des onglets
            function showTab(tabId) {
                const tabs = document.querySelectorAll('.tab-content');
                tabs.forEach(tab => tab.classList.remove('active'));
                const buttons = document.querySelectorAll('.tab-button');
                buttons.forEach(button => button.classList.remove('active'));
                document.getElementById(tabId).classList.add('active');
                event.target.classList.add('active');
            }
            
            // Ajout d'une nouvelle langue via JS
            function addNewLanguage() {
                const langCode = document.getElementById('new_lang_code').value.trim().toLowerCase();
                if (!langCode || !/^[a-z]{2}$/.test(langCode)) {
                    document.getElementById('lang_message').innerHTML = '<span style="color: red;">Veuillez entrer un code de langue valide (2 lettres minuscules).</span>';
                    return;
                }
                
                // Créer un formulaire dynamique pour l'ajout
                const form = document.createElement('form');
                form.method = 'POST';
                form.action = '?action=add_language';
                
                const input = document.createElement('input');
                input.type = 'hidden';
                input.name = 'new_lang_code';
                input.value = langCode;
                
                form.appendChild(input);
                document.body.appendChild(form);
                form.submit();
            }
        </script>
    <?php endif; ?>
</body>
</html>