<?php
/**
 * Rélisation du système de commentaires en PHP/JS par c2script.com
 */
session_start();

// Générer un code captcha de 4 caractères (lettres et chiffres)
$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
$captcha_code = '';
for ($i = 0; $i < 4; $i++) {
    $captcha_code .= $characters[rand(0, strlen($characters) - 1)];
}

// Stocker le code en session
$_SESSION['captcha'] = $captcha_code;

// Créer l'image
$image = imagecreatetruecolor(100, 30);
$bg_color = imagecolorallocate($image, 255, 255, 255); // Blanc
$text_color = imagecolorallocate($image, 0, 0, 0); // Noir
$noise_color = imagecolorallocate($image, 200, 200, 200); // Gris pour le bruit

// Remplir le fond
imagefilledrectangle($image, 0, 0, 100, 30, $bg_color);

// Ajouter du bruit
for ($i = 0; $i < 100; $i++) {
    imagesetpixel($image, rand(0, 100), rand(0, 30), $noise_color);
}

// Écrire le texte
imagestring($image, 5, 25, 5, $captcha_code, $text_color);

// Envoyer l'image
header('Content-Type: image/png');
imagepng($image);