<?php
// Configuration du système de commentaires

$C2PARAM = array();

// Mode de validation : 'direct' ou 'ftp'
$C2PARAM['validation_mode'] = 'direct';

// Mot de passe pour l'administration
$C2PARAM['admin_password'] = 'motdepasseadmin';

// Email de l'administrateur pour les notifications
$C2PARAM['admin_email'] = 'admin@example.com';

// Configuration SMTP pour PHPMailer
$C2PARAM['use_smtp'] = false;
$C2PARAM['smtp_host'] = 'smtp.example.com';
$C2PARAM['smtp_username'] = 'votreemail@example.com';
$C2PARAM['smtp_password'] = 'votremotdepasse';
$C2PARAM['smtp_port'] = 587;
$C2PARAM['smtp_secure'] = 'tls';

// Dossier pour les commentaires JSON
$C2PARAM['comments_dir'] = __DIR__ . '/commentaires/';

// Configuration pour afficher les commentaires récents en premier (true) ou anciens en premier (false)
$C2PARAM['recent_first'] = true;

// Configuration pour afficher les boutons "répondre" aux commentaires
$C2PARAM['afficher_boutons_repondre'] = true;

// Profondeur maximale des réponses (0 = pas de réponses, 1 = réponses aux commentaires principaux, 2 = réponses aux réponses, etc.)
$C2PARAM['max_reply_depth'] = 1;

// URL du site pour les commentaires
if (isset($_SERVER['HTTP_HOST']) && strpos($_SERVER['HTTP_HOST'], 'localhost') !== false) {
    $C2PARAM['URL_SITE'] = 'http://localhost/travaux/nemodus';
} else {
    $C2PARAM['URL_SITE'] = 'https://example1.com'; // sans slash à la fin
}

// Configuration anti-spam
$C2PARAM['min_form_time'] = 5;
$C2PARAM['captcha_type'] = 'none';
$C2PARAM['hcaptcha_sitekey'] = '35948516-da1c-4a0c-b85a-446482fc8d8e';
$C2PARAM['hcaptcha_secretkey'] = 'ES_7e5095eacf9b4312938e8577f79c9e78';
$C2PARAM['hcaptcha_size'] = 'normal';
$C2PARAM['max_comment_length'] = 1000;
$C2PARAM['comment_truncate_lines'] = 3;
$C2PARAM['read_more_color'] = '#007bff';
$C2PARAM['read_more_size'] = '14px';
$C2PARAM['comments_per_page'] = 3;
$C2PARAM['display_mode'] = 'add_and_view';


include 'translations.php';

// Fonction pour récupérer les traductions
function getTranslation($key) {
    global $C2PARAM;
    $lang = $C2PARAM['current_language'] ?? 'fr';
    return $C2PARAM['translations'][$lang][$key] ?? $key;
}

// Configuration de la langue actuelle
$C2PARAM['current_language'] = 'fr';

// Chemin d'installation par défaut pour le générateur de code
$C2PARAM['default_install_path'] = './systeme-commentaires';

// ID de page par défaut pour le générateur de code
$C2PARAM['default_page_id'] = 'page_54';

// Traductions par langue
$C2PARAM['translations'] = $translations;


// Configuration du thème et de la personnalisation
$C2PARAM['theme'] = array();

// Éléments du formulaire
$C2PARAM['theme']['form'] = array(
    'text_size' => '24px',
    'color' => '#2f5496'
);

$C2PARAM['theme']['pseudo'] = array(
    'text_size' => '16px',
    'color' => '#2f5496',
    'margin_left' => '10px'
);

$C2PARAM['theme']['site_web'] = array(
    'enabled' => true,
    'text_size' => '16px',
    'color' => '#2f5496',
    'margin_left' => '10px'
);

$C2PARAM['theme']['commentaire'] = array(
    'text_size' => '24px',
    'color' => '#2f5496'
);

$C2PARAM['theme']['commentaire_field'] = array(
    'text_size' => '13px',
    'color' => '#2f5496',
    'margin_left' => '10px'
);

$C2PARAM['theme']['captcha'] = array(
    'text_size' => '24px',
    'color' => '#2f5496',
    'margin_left' => '10px'
);

// Cadre du formulaire
$C2PARAM['theme']['form_border'] = array(
    'color' => '#2f5496'
);

$C2PARAM['theme']['form_focus'] = array(
    'border_color' => '#2f5496'
);

// Boutons et liens
$C2PARAM['theme']['button_comment'] = array(
    'type' => 'button',
    'text_size' => '16px',
    'bg_color' => '#2f5496',
    'hover_color' => '#4040c0'
);

$C2PARAM['theme']['button_submit'] = array(
    'text_size' => '13px',
    'bg_color' => '#2f5496',
    'hover_color' => '#4040c0',
    'margin_left' => '10px'
);

$C2PARAM['theme']['button_reply'] = array(
    'type' => 'button',
    'text_size' => '16px',
    'bg_color' => '#2f5496',
    'hover_color' => '#4040c0'
);

// Options générales des boutons
$C2PARAM['theme']['buttons'] = array(
    'border_radius' => '4px'
);
$C2PARAM['buttons_margin_top'] = '10px';
$C2PARAM['button_submit_alignment'] = 'left';

// Configuration du mode clair/sombre
$C2PARAM['theme_toggle'] = array(
    'alignment' => 'right',
    'text_size' => '24px'
);

// Autres configurations si nécessaire
?>